#ifndef GOCAD_PARSER_HPP
#define GOCAD_PARSER_HPP

#include <boost/shared_ptr.hpp>
#include <buildspec.h>
#include <iosfwd>
#include <string>

namespace GST
{

namespace Utils
{

class IPartCountProgress;

}

namespace Parsers
{

class IParsingActions;

namespace GocadParser
{

/**
parseGocadFile()

	Assumptions:

		Gocad file has the same line endings as the platform the program is
compiled on. Gocad file has valid syntax and semantic. Names, identifiers and
properties contain no space or " in their values.

	input:

		stream: std::istream of a Gocad file,
		p: Implementation of the IParsingActions interface
		requestedGeometryType: Parser will only create geometries of
geometryType (if geometryType == GeoCollection, it will create all known
geometries) requestedPropertyAlignment: Parser will only create properties of
propertyAlignment (Vertex or Cell)


	Output:

		0: No error
		1: Error while reading the file
		2: Not supported Type
		3: Not supported AxisUnit (aka different from m)

*/

/**
 * Opens file filename and pass the ifilestream to parseGocadFile(std::istream&,
 * ...)
 */
int GST_API_EXPORT parseGocadFile(std::istream &stream,
								  boost::shared_ptr<IParsingActions> p,
								  const std::string &requestedGeometryType,
								  const std::string &requestedPropertyAlignment,
								  bool onlyMetaData = false,
								  Utils::IPartCountProgress *progress = NULL);

} // namespace GocadParser
} // namespace Parsers
} // namespace GST

#endif // GOCAD_PARSER_HPP
